using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Reflection;
using System.Text.RegularExpressions;

namespace screamer_c
{
    public partial class screamer : Form
    {
        Bitmap bmpRedCircle = null;

        int CommPort;
        double CommSpeed;
        Double PICSpeed;
        String PICType;
        Double TermBaud;
        String TermParity;
        Double TermStopBits;
        int TermDataBits;
        Boolean TermAutoLaunch;
        Boolean TermMode;
        String TermType;
        Boolean TermEcho;
        String[] txtUserFile = new String[3];

        Boolean Stop_Waiting;

        //MSCommLib.MSCommClass MSComm1 = new MSCommLib.MSCommClass();
        delegate void SetTextCallback(string text);

        public screamer()
        {
            InitializeComponent();
            bmpRedCircle = new Bitmap(16, 16);
            Graphics g = Graphics.FromImage(bmpRedCircle);
            g.FillEllipse(Brushes.Red, new Rectangle(0, 0, 16, 16));
            //sptComplete.Image = sptConnect.Image = sptDownload.Image = bmpRedCircle;
            serialPort1.DataReceived += new System.IO.Ports.SerialDataReceivedEventHandler(serialPort1_DataReceived);
        }

        void serialPort1_DataReceived(object sender, System.IO.Ports.SerialDataReceivedEventArgs e)
        {
           // System.Diagnostics.Debug.WriteLine("Recive data");
        }

        private void toolStripMenuItem2_Click(object sender, EventArgs e)
        {
            using (About a = new About())
            {
                a.ShowDialog();
            }
        }

        private void cboBaud_SelectedIndexChanged(object sender, EventArgs e)
        {
            CommSpeed = double.Parse(cboBaud.SelectedItem.ToString());
        }

        private void cboOscillator_SelectedIndexChanged(object sender, EventArgs e)
        {
            PICSpeed = double.Parse(cboOscillator.SelectedItem.ToString());
        }

        #region GLOBALS
        /// GLOBALS START HERE

        /// <summary>
        /// 
        /// </summary>
        /// <param name="bolEnable"></param>
        private void TermWindow(bool bolEnable)
        {
            // TODO: On Error GoTo Warning!!!: The statement is not translatable 
            if (bolEnable)
            {
                lblStatus.Text = "Debug";
                chkTerm.Checked = true;
                txtTerm.Enabled = true;
                txtTerm.ForeColor = Color.Black;
                timer1.Interval = 10;
                timer1.Enabled = true;
            }
            else
            {
                lblStatus.Text = "Idle";
                chkTerm.Checked = false;
                txtTerm.Enabled = false;
                timer1.Enabled = false;
            }
            try
            {
                if ((TermMode && !bolEnable))
                {
                    #region old code
                    //if ((MSComm1.PortOpen == true))
                    //    MSComm1.PortOpen = false;
                    #endregion
                    if (serialPort1.IsOpen)
                        serialPort1.Close();
                }
                TermMode = bolEnable;
                if (!bolEnable)
                {
                    return;
                }
                TermMode = true;
                tabControl1.SelectedIndex = 1;
                // With...
                #region old code
                //    if ((MSComm1.PortOpen == true))
                //    {
                //        MSComm1.PortOpen = false;
                //    }
                //    MSComm1.CommPort = (short)CommPort;
                //    MSComm1.InputLen= 0;
                //    MSComm1.Handshaking = MSCommLib.HandshakeConstants.comNone;
                //    MSComm1.RTSEnable = false;
                //    MSComm1.RThreshold = 1;
                //    MSComm1.SThreshold = 1;
                //    MSComm1.InBufferSize = 1024; 
                //MSComm1.InBufferSize = 1024;

                //    // .Settings = TermBaud & ","
                //    MSComm1.Settings = TermBaud + "," + TermParity + "," + TermDataBits + "," + TermStopBits;
                //    MSComm1.PortOpen = true; 
                #endregion
                if (serialPort1.IsOpen)
                {
                    serialPort1.Close();
                }
                serialPort1.PortName = "COM" + CommPort.ToString();
                serialPort1.Handshake = System.IO.Ports.Handshake.None;
                serialPort1.RtsEnable = false;
                //serialPort1.ReceivedBytesThreshold = 1;
                //serialPort1.ReadBufferSize = 1024;
                serialPort1.BaudRate = (int)TermBaud;
                switch (TermParity.ToLower())
                {
                    case "o":
                        serialPort1.Parity = System.IO.Ports.Parity.Odd;
                        break;
                    case "e":
                        serialPort1.Parity = System.IO.Ports.Parity.Even;
                        break;
                    default:
                        serialPort1.Parity = System.IO.Ports.Parity.None;
                        break;
                }
                serialPort1.DataBits = TermDataBits;
                switch ((int)TermStopBits * 10)
                {
                    case 10:
                        serialPort1.StopBits = System.IO.Ports.StopBits.One;
                        break;
                    case 15:
                        serialPort1.StopBits = System.IO.Ports.StopBits.OnePointFive;
                        break;
                    case 20:
                        serialPort1.StopBits = System.IO.Ports.StopBits.Two;
                        break;
                    default:
                        serialPort1.StopBits = System.IO.Ports.StopBits.None;
                        break;
                }
                serialPort1.Open();
                //MSComm1.Settings = true;
                txtTerm.Focus();
                //return;
                #region old code
                //// TODO: CHECK THIS
                ////if ((Err.Number == 8005))
                //{
                //    MessageBox.Show("COM" + CommPort + " already open.");
                //    chkTerm.Checked = false;
                //    lblStatus.Text = "Error";
                //} 
                #endregion

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
                chkTerm.Checked = false;
                lblStatus.Text = "Error";
            }
        }

        private string StringToHex(string s)
        {
            int i;
            int j;
            string result = "";
            for (i = 0; i < s.Length; i++)
            {
                j = (int)s[i];
                result = (result + (" " + ((j < 17) ? ("0" + j.ToString("X")) : j.ToString("X"))));//TODO: isn't 16 should be instead of 17?
            }
            return result;
            //return int.Parse(s).ToString("X");
        }

        private void cboChip_Click()
        {
            //PICType = cboChip.List(cboChip.ListIndex);
        }

        private void cboCommPort_Click()
        {
            //CommPort = (cboCommPort.ListIndex + 1);
        }

        private void GetSerial()
        {
            string buffer;
            #region old code
            //if ((MSComm1.PortOpen == false)) 
            #endregion
            if (!serialPort1.IsOpen)
            {
                return;
            }
            if (TermMode)
            {
            #region old code 
		    //if ((MSComm1.InBufferCount > 0))
                //{
                //    buffer = MSComm1.Input.ToString(); 
	        #endregion
                if ((serialPort1.BytesToRead > 0))
                {
                    buffer = Encoding.GetEncoding("Windows-1252").GetString(Input(100));
                    switch (TermType)
                    {
                        case "asc":
                            break;
                        case "dec":
                            buffer = StringToDec(buffer);
                            break;
                        case "hex":
                            buffer = StringToHex(buffer);
                            break;
                    }
                    if ((txtTerm.Text.Length > 15000))
                    {
                        txtTerm.Text = txtTerm.Text.Substring(txtTerm.Text.Length - 10000, 10000);
                    }
                    txtTerm.SelectionStart = txtTerm.Text.Length;
                    txtTerm.SelectedText = buffer;
                    txtTerm.SelectionStart = txtTerm.Text.Length;
                }
            }
        }
        private int Hex_Convert(string nate)
        {
            //           // This function takes a two character string and converts it to an integer
            //long new_hex;
            //int temp;
            //int i;
            //new_hex = 0;
            //for (i = 0; (i 
            //            <= (nate.Length - 1)); i++) {
            //    // Peel off first letter
            //    temp = AscB(nate.Substring(0, (1 + i)).Substring((nate.Substring(0, (1 + i)).Length - 1)));
            //    // Convert it to a number
            //    if (((temp >= AscB("A")) 
            //                && (temp <= AscB("F")))) {
            //        temp = ((temp - AscB("A")) 
            //                    + 10);
            //    }
            //    else if (((temp >= AscB("0")) 
            //                && (temp <= AscB("9")))) {
            //        temp = (temp - AscB("0"));
            //    }
            //    // Shift the number
            //    new_hex = ((new_hex * 16) 
            //                + temp);
            //}
            //return new_hex;
            return int.Parse(nate, System.Globalization.NumberStyles.AllowHexSpecifier);
        }

        double RoundNear(double varNumber, double varDelta)
        {
            // ***********
            // Name:      RoundNear (Function)
            // Purpose:   rounds varnumber to the nearest fraction equal
            //    varDelta
            // Inputs:    varNumber - number to round
            //            varDelta - the fraction used as measure of
            //    rounding
            // Example:   RoundNear(53,6) = 54
            //            RoundNear(1.16,0.25) = 1.25
            //            RoundNear(1.12,0.25) = 1.00
            //            RoundNear(1.125,0.25)= 1.25
            // Output:    varNumber rounded to nearest
            //            multiple of varDelta.
            // ***********
            double varX = (varNumber / varDelta);
            int intX = (int)varX;
            double varDec = varX - intX;
            if ((varDec >= 0.5))
            {
                return (varDelta * (intX + 1));
            }
            else
            {
                return (varDelta * intX);
            }
        }

        private void SetDefaults()
        {
            //cboCommPort.SelectedIndex = 0;
            cboBaud.SelectedIndex = 0;
            cboOscillator.SelectedIndex = 1;
            //cboChip.SelectedIndex = 0;
            cboTermSpeed.SelectedIndex = 3;
            cboTermDataBits.SelectedIndex = 1;
            cboTermParity.SelectedIndex = 2;
            cboTermStopBits.SelectedIndex = 0;
            optAsc.Checked = true;
            chkLaunchTerm.Checked = true;
        }

        private string StringToDec(string s)
        {
            string result = "";
            for (int i = 0; i < s.Length; i++)
            {
                result = (result + (" " + string.Format("{0:000}", (int)s[i])));
            }
            return result;
            //return int.Parse(s);
        }
        // GLOBALS END HERE
        #endregion

        private void txtTerm_KeyPress(object sender, KeyPressEventArgs e)
        {
            #region old code
            //if (MSComm1.PortOpen) MSComm1.Output = e.KeyChar; 
            #endregion
            //!!!! char is UniCode (2 bytes) type, maybe replace with byte? 
            if (serialPort1.IsOpen)
            {
                byte[] send = Encoding.ASCII.GetBytes(new char[1] { e.KeyChar });
                serialPort1.Write(send, 0, 1);
            }
            if (!TermEcho) e.KeyChar = '\0';
        }

        private void cboTermDataBits_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (TermDataBits != int.Parse(cboTermDataBits.Text))
            {
                TermDataBits = int.Parse(cboTermDataBits.Text);
                if (TermMode) TermWindow(true);
            }
        }

        private void cboTermParity_SelectedIndexChanged(object sender, EventArgs e)
        {
            if ((TermParity != cboTermParity.Text))
            {
                TermParity = cboTermParity.Text;
                if (TermMode)
                {
                    TermWindow(true);
                }
            }
        }

        private void cboTermSpeed_SelectedIndexChanged(object sender, EventArgs e)
        {
            if ((TermBaud != double.Parse(cboTermSpeed.Text)))
            {
                TermBaud = double.Parse(cboTermSpeed.Text);
                if (TermMode)
                {
                    TermWindow(true);
                }
            }
        }

        private void cboTermStopBits_SelectedIndexChanged(object sender, EventArgs e)
        {
            if ((TermStopBits != double.Parse(cboTermStopBits.Text)))
            {
                TermStopBits = double.Parse(cboTermStopBits.Text);
                if (TermMode)
                {
                    TermWindow(true);
                }
            }
        }

        private void chkTerm_CheckedChanged(object sender, EventArgs e)
        {
            if (chkTerm.Checked)
                TermWindow(true);
            else
                TermWindow(false);
        }

        private void chkLaunchTerm_CheckedChanged(object sender, EventArgs e)
        {
            TermAutoLaunch = chkLaunchTerm.Checked;
        }

        private void chkTermEcho_CheckedChanged(object sender, EventArgs e)
        {
            TermEcho = chkTermEcho.Checked;
        }

        private void cmdBreak_Click(object sender, EventArgs e)
        {
            Stop_Waiting = true;
        }

        private void cmdClearDebug_Click(object sender, EventArgs e)
        {
            txtTerm.Text = "";
            if (TermMode) txtTerm.Focus();
        }
        private void Output(int v)
        {
            byte[] buff = new byte[1];
            buff[0] = (byte)v;
            serialPort1.Write(buff, 0, 1);
        }

        private byte[] Input(int max)
        {
            if (serialPort1.BytesToRead < max)
            {
                max = serialPort1.BytesToRead;
            }

            byte[] data = new byte[max];
            serialPort1.Read(data, 0, max);
            return data;
        }

        private void cmdDownload_Click(object sender, EventArgs e)
        {
            TextBox tb = null;
            if (sender == cmdDownload1)
                tb = txtFile1;
            else if (sender == cmdDownload2)
                tb = txtFile2;
            else if (sender == cmdDownload3)
                tb = txtFile3;
            string Text1 = "";
            cmdBreak.Enabled = true;
            try
            {
                object outBuffer;
                object totalLen;
                //object currentLen;
                //int fnum;
                string[] fileContentLines;
                long i;
                int j;
                //string nate;
                //int temp;
                int Record_Length = 0;
                int DownloadSpeed;
                int Memory_Address_High;
                int Memory_Address_Low;
                int End_Record;
                int[] Outgoing_Data = new int[51];
                int Check_Sum;
                int Bloader_Start_High;
                int Bloader_Start_Low;
                //int User_Boot_Vector_High;
                //int User_Boot_Vector_Low;
                byte[] temp_block = new byte[100];
                int Total_Code_Words;

                TermMode = false;
                TermWindow(false);

                //Reset the user break command
                Stop_Waiting = false;
                Total_Code_Words = 0;
                lblDownload.Text = "Downloading...";

                //If port already opened then close it
                #region old code
                //if (MSComm1.PortOpen == true)
                //{
                //    MSComm1.Output = (char)4; // output the magic character to kick off download
                //    MSComm1.PortOpen = false;
                //} 
                #endregion
                if (serialPort1.IsOpen)
                {
                    Output(4);
                    serialPort1.Close();
                }
                //Read in the HEX file - clean it up
                if (tb.Text != "")
                {
                    //fnum = FreeFile();
                    //Open txtFile(Index).Text For Input As #fnum

                    ////Read each line into fileContentLines() array
                    //fileContentLines() = Split(Input(LOF(fnum), fnum), vbCrLf)
                    //Close #fnum
                    fileContentLines = File.ReadAllLines(tb.Text);

                    //Remove empty lines + lines not starting with a ":"
                    for (i = 0; i < fileContentLines.Length; i++)
                    {
                        if (fileContentLines[i].Length == 0) fileContentLines[i] = '\0'.ToString();
                        if (fileContentLines[i].Substring(0, 1) != ":") fileContentLines[i] = '\0'.ToString();
                        if (fileContentLines[i].Substring(/*8*/7, 2) == "04") fileContentLines[i] = '\0'.ToString();
                    }

                    // get only not empty strings
                    List<string> s = new List<string>();
                    foreach (string _s in fileContentLines)
                        if (_s != null && _s != "")
                            s.Add(_s);
                    fileContentLines = s.ToArray();
                    totalLen = fileContentLines.Length - 1;
                }
                else
                {
                    MessageBox.Show("Error, no HEX file found");
                    return;
                }
                lblDownloadBarBG.Maximum = (int) totalLen;
                //sptConnect1.FillColor = Color.Red;
                //sptDownload1.FillColor = Color.Red;
                //sptComplete1.FillColor = Color.Red;

                lblResend.Text = 0.ToString();
                lblDownload.Text = "Running...";

                //Calculate download speed
                //This is the SPBRG register value that will be sent to the PIC
                DownloadSpeed = (int)RoundNear(PICSpeed * 1000000 / (16 * CommSpeed) - 1, 0.25);

                //MsgBox DownloadSpeed
                //Exit Sub

                //Check to see if the PIC is outputting the load key ASC(5)
                lblStatus.Text = "Waiting for PIC boot broadcast";
                #region old code
                //MSComm1.CommPort = (short)CommPort;
                //MSComm1.InputLen = 1;
                //MSComm1.Settings = "9600,n,8,1";
                //MSComm1.PortOpen = true; 
                #endregion
                serialPort1 = new System.IO.Ports.SerialPort("COM" + CommPort.ToString(), 
                        9600, System.IO.Ports.Parity.None, 8, System.IO.Ports.StopBits.One);
                serialPort1.Open();

                //Disable certain buttons
                cmdDownload1.Enabled = false;
                cmdDownload2.Enabled = false;
                cmdDownload3.Enabled = false;
                cmdOpen1.Enabled = false;
                cmdOpen2.Enabled = false;
                cmdOpen3.Enabled = false;
                cmdBreak.Enabled = true;
                cmdBreak.Text = "&Stop Waiting";



                #region old code
		                //while (/*(char)*/MSComm1.Input != /*(char)(5)*/(object)5)
                //{ 
	            #endregion
                while(true)
                {
                    if (serialPort1.BytesToRead > 0)
                    {
                        if (Input(1)[0] == 5)
                        {
                            break;
                        }
                    }
                    //See if user wants to stop
                    if (Stop_Waiting == true)
                    {
                        MessageBox.Show("The PIC did not enter load mode.");

                        lblStatus.Text = "Idle";
                        lblDownload.Text = "Idle";
                        cmdDownload1.Enabled = true;
                        cmdDownload2.Enabled = true;
                        cmdDownload3.Enabled = true;
                        cmdBreak.Enabled = false;
                        cmdOpen1.Enabled = true;
                        cmdOpen2.Enabled = true;
                        cmdOpen3.Enabled = true;
                        return;
                    }

                    Application.DoEvents();

                }
                cmdBreak.Text = "Abort";

                //Output 6 to cause the PIC to go into load mode
                lblStatus.Text = "Got PIC broadcast, sending prompt";
                //sptConnect1.FillColor = Color.Green; //Green
                #region old code
                //MSComm1.Output = (char)6; 
                #endregion
                Output(6);

                //Transmit the user's download speed
                lblStatus.Text = "Got PIC broadcast, sending downloadspeed";
                #region old code
                //MSComm1.Output = (char)DownloadSpeed; 
                #endregion
                Output(DownloadSpeed);

                //Now move to the new speed
                if (CommSpeed != 9600)
                {
                    #region old code
                    //MSComm1.PortOpen = false;
                    //MSComm1.Settings = CommSpeed + ",n,8,1";
                    //MSComm1.PortOpen = true; 
                    #endregion
                    serialPort1.Close();
                    serialPort1.BaudRate = (int)CommSpeed;
                    serialPort1.Parity = System.IO.Ports.Parity.None;
                    serialPort1.DataBits = 8;
                    serialPort1.StopBits = System.IO.Ports.StopBits.One;
                    serialPort1.Open();
                }
                lblStatus.Text = "Got PIC broadcast, waiting for bloader location";

                //Snag the bloader starting memory location info from PIC
                #region old code
                //while (MSComm1.InBufferCount < 2) 
                #endregion
                while (serialPort1.BytesToRead < 2)
                {
                    //See if user wants to stop
                    if (Stop_Waiting == true)
                    {
                        MessageBox.Show("The PIC did not finish loading. You will likely experience unexpected program execution.");

                        lblStatus.Text = "Idle";
                        lblDownload.Text = "Idle";
                        cmdDownload1.Enabled = true;
                        cmdDownload2.Enabled = true;
                        cmdDownload3.Enabled = true;
                        cmdBreak.Enabled = false;
                        cmdOpen1.Enabled = true;
                        cmdOpen2.Enabled = true;
                        cmdOpen3.Enabled = true;

                        return;
                    }

                    Application.DoEvents();
                }
                #region old code
                //Bloader_Start_High = (int)(char)MSComm1.Input;// '31 '0x1F
                //Bloader_Start_Low = (int)(char)MSComm1.Input; 
                #endregion
                byte[] rcv = Input(2);
                Bloader_Start_High = rcv[0];// '31 '0x1F
                Bloader_Start_Low = rcv[1]; 
                //Bloader_Jump_Low = Asc(MSComm1.Input)

                for (i = 0; i < fileContentLines.Length; i++)
                {

                    //See if user wants to stop
                    if (Stop_Waiting == true)
                    {
                        MessageBox.Show("The PIC did not finish loading. You will likely experience unexpected program execution.");

                        lblStatus.Text = "Idle";
                        lblDownload.Text = "Idle";
                        cmdDownload1.Enabled = true;
                        cmdDownload2.Enabled = true;
                        cmdDownload3.Enabled = true;
                        cmdBreak.Enabled = false;
                        cmdOpen1.Enabled = true;
                        cmdOpen2.Enabled = true;
                        cmdOpen3.Enabled = true;

                        return;
                    }

                    //Wait for PIC to tell us he's ready
                    InfoLabel.Text = "Waiting for pic";
                    //InfoLabel.Refresh
                    #region old code
                    //while (MSComm1.InBufferCount == 0)
                    #endregion  
                    while (serialPort1.BytesToRead == 0)
                    {
                        Application.DoEvents();

                        //See if user has aborted - most likely freeze error
                        if (Stop_Waiting == true)
                        {
                            MessageBox.Show("The PIC did not finish loading. You will likely experience unexpected program execution.");

                            lblStatus.Text = "Idle";
                            lblDownload.Text = "Idle";
                            cmdDownload1.Enabled = true;
                            cmdDownload2.Enabled = true;
                            cmdDownload3.Enabled = true;
                            cmdBreak.Enabled = false;
                            cmdOpen1.Enabled = true;
                            cmdOpen2.Enabled = true;
                            cmdOpen3.Enabled = true;

                            return;
                        }
                    }

                    #region old code
                    //Text1 = MSComm1.Input.ToString(); 
                    #endregion
                    Text1 = System.Text.Encoding.ASCII.GetString(Input(1)); //serialPort1.ReadExisting();
                    InfoLabel.Text = "Got response from PIC";
                    //InfoLabel.Refresh

                    if (Text1 == "T")
                    { //All is well
                        //sptDownload1.FillColor = Color.Green; //Green
                        Total_Code_Words = Total_Code_Words + (Record_Length / 2);
                    }
                    else if (Text1 == ((char)(7)).ToString())
                    { //Re-send line
                        i = i - 1;
                        lblResend.Text = lblResend.Text + 1;
                        //sptDownload1.FillColor = Color.Yellow; //Yellow
                        Application.DoEvents();
                    }
                    else
                    {
                        MessageBox.Show("Error : Incorrect response - " + Text1 + " from PIC. Programming is incomplete and will now halt. Did you set the baud rate correctly?");

                        lblStatus.Text = "Idle";
                        lblDownload.Text = "Idle";
                        cmdDownload1.Enabled = true;
                        cmdDownload2.Enabled = true;
                        cmdDownload3.Enabled = true;
                        cmdBreak.Enabled = false;
                        cmdOpen1.Enabled = true;
                        cmdOpen2.Enabled = true;
                        cmdOpen3.Enabled = true;

                        return;
                    }

                Hard_Coded_Next_line:

                    //Pull the next line from the file
                    InfoLabel.Text = "Get next line from file";
                    //InfoLabel.Refresh

                    //i = 0
                    outBuffer = fileContentLines[i];
                    lblCurrentBuffer.Text = fileContentLines[i];

                    //Do the fancy GUI updates
                    lblStatus.Text = "Loaded " + Total_Code_Words + " code words";
                    lblDownloadBarBG.Value = (int)i; //(int)(lblDownloadBarBG.Width * (i / (int)totalLen));
                    lblDownloadBarBG.Refresh();
                    Application.DoEvents();
                    label4.Text = "At " + i.ToString() + " of " + totalLen.ToString();

                    //Here is where we rearrange data for direct sending
                    //=============================================
                    Text1 = fileContentLines[i];

                    //Peel off ':'
                    Text1 = Text1.Substring(1, Text1.Length - 1);

                    //Peel off record length
                    Record_Length = Hex_Convert(Text1.Substring(0, 2));
                    Text1 = Text1.Substring(2, Text1.Length - 2);
                    //Catch a record length that is less than a multiple of 8
                    int Length_Padding;
                    Length_Padding = 0;
                    while (((Record_Length + Length_Padding) % 8) != 0)
                    {
                        Length_Padding = Length_Padding + 1;
                    }

                    //Peel off memory address
                    Memory_Address_High = Hex_Convert(Text1.Substring(0, 2));
                    Text1 = Text1.Substring(2, Text1.Length - 2);
                    Memory_Address_Low = Hex_Convert(Text1.Substring(0, 2));
                    Text1 = Text1.Substring(2, Text1.Length - 2);

                    //Divide Memory address by 2
                    if ((Memory_Address_High % 2) != 0) Memory_Address_Low = Memory_Address_Low + 256;
                    Memory_Address_High = Memory_Address_High / 2;
                    Memory_Address_Low = Memory_Address_Low / 2;

                    //If this memory address is in the boot loader memory space, skip it!
                    if (Memory_Address_High == Bloader_Start_High)
                    {
                        if (Memory_Address_Low >= Bloader_Start_Low - 8)
                        {

                            if (lblDownload.Text != "HEX File too long")
                            {
                                lblDownload.Text = "HEX File too long";
                                MessageBox.Show("This HEX File spills over into reserved Bloader space. You may experience unexpected program execution.");
                                MessageBox.Show("Stopping boot load!");
                                //goto ErrExit;
                                throw new Exception("This HEX File spills over into reserved Bloader space. You may experience unexpected program execution.\nStopping boot load!");

                            }
                            i = i + 1;
                            goto Hard_Coded_Next_line;

                        }
                    }
                    //If this memory address is in the config word space, skip it!
                    if (Memory_Address_High >= 64)
                    { //32 = 0x20 = 0x40 / 2
                        i = i + 1;
                        goto Hard_Coded_Next_line;
                    }

                    //============================================================

                    //Peel off and check for end of file tage
                    End_Record = Hex_Convert(Text1.Substring(0, 2));
                    Text1 = Text1.Substring(2, Text1.Length - 2);
                    if (End_Record == 1)
                    {
                        goto Last_Line;
                    }

                    //Calculate our OWN Checksum
                    Check_Sum = Record_Length + Length_Padding + Memory_Address_High + Memory_Address_Low;

                    //Load program data into the outgoing_data array
                    for (j = 0; j <= (Record_Length / 2) - 1; j++)
                    {
                        //Catch first byte and store it in second spot
                        Outgoing_Data[(j * 2) + 1] = Hex_Convert(Text1.Substring(0, 2));
                        Text1 = Text1.Substring(2, Text1.Length - 2);

                        //Catch second byte and store it in first spot
                        Outgoing_Data[j * 2] = Hex_Convert(Text1.Substring(0, 2));
                        Text1 = Text1.Substring(2, Text1.Length - 2);

                        //This is the very special case of the boot vector
                        //Memory location 0 should be a goto main
                        //We will insert the bloader jump vector and shift the goto main to
                        //memory location 4
                        //If Memory_Address_High = 0 And Memory_Address_Low = 0 Then
                        //Make sure the user has created the HEX file properly with
                        //the required pragma origin statement
                        //   If Record_Length <> 2 Then
                        //       MsgBox "This HEX file does not appear to have the correct goto statement. Please double check that the proper 'origin 4' statement has been inserted at the beginning of the C program."
                        //       GoTo ErrExit
                        //   End If

                        //Originally we broadcasted the entire boot vector to the PIC. This has since
                        //been moved to the PIC so that the boot vector is ALWAYS written during
                        //a boot load so that we don't run the risk of losing it.

                        //6-10-04 While this protected boot vector worked great for the 16F88, it causes the 16F87xA series
                        //to overwrite the boot vector... So now we need a chip select! Great...

                        //   If PICType = "16F88" Then
                        //Repoint initial user's goto
                        //       Outgoing_Data(6) = Outgoing_Data(0)
                        //       Outgoing_Data(7) = Outgoing_Data(1)
                        //0x158A
                        //       Outgoing_Data(0) = Hex_Convert("3F")
                        //       Outgoing_Data(1) = Hex_Convert("FF")
                        //0x160A
                        //       Outgoing_Data(2) = Hex_Convert("3F")
                        //       Outgoing_Data(3) = Hex_Convert("FF")
                        //0x2F99
                        //       Outgoing_Data(4) = Hex_Convert("3F")
                        //       Outgoing_Data(5) = Hex_Convert("FF")
                        //  ElseIf PICType = "16F877A" Or PICType = "16F876A" Or PICType = "16F873A" Then
                        //Repoint initial user's goto
                        //      Outgoing_Data(6) = Outgoing_Data(0)
                        //      Outgoing_Data(7) = Outgoing_Data(1)
                        //0x158A
                        //      Outgoing_Data(0) = Hex_Convert("15")
                        //      Outgoing_Data(1) = Hex_Convert("8A")
                        //0x160A
                        //      Outgoing_Data(2) = Hex_Convert("16")
                        //      Outgoing_Data(3) = Hex_Convert("0A")
                        //0x2F40
                        //      Outgoing_Data(4) = Hex_Convert("2F")
                        //      Outgoing_Data(5) = Hex_Convert("40")
                        // End If


                        //Fix Checksum
                        //  Check_Sum = Check_Sum + Outgoing_Data(2) + Outgoing_Data(3) + Outgoing_Data(4) + Outgoing_Data(5) + Outgoing_Data(6) + Outgoing_Data(7)
                        //Reset padding
                        //  Length_Padding = 0
                        //  Record_Length = 8
                        // End If

                        Check_Sum = Check_Sum + Outgoing_Data[j * 2];
                        Check_Sum = Check_Sum + Outgoing_Data[(j * 2) + 1];
                    }

                    //Add padding if this hex line is less than a multiple of 4
                    for (j = (Record_Length / 2); j <= (Length_Padding / 2) + (Record_Length / 2) - 1; j++)
                    {
                        //Add padding
                        Outgoing_Data[j * 2] = 63; //3F
                        Outgoing_Data[(j * 2) + 1] = 255; //FF

                        Check_Sum = Check_Sum + Outgoing_Data[j * 2];
                        Check_Sum = Check_Sum + Outgoing_Data[(j * 2) + 1];
                    }

                    //Now reduce check_sum to 8 bits
                    while (Check_Sum >= 256)
                        Check_Sum = Check_Sum - 256;

                    //Now take 2's compliment
                    Check_Sum = 256 - Check_Sum;
                    //Catch the special case
                    if (Check_Sum == 256) Check_Sum = 0;

                    InfoLabel.Text = "Sending start character";
                    //InfoLabel.Refresh


                    //=============================================
                    //Send the start character
                    int bcount = 0;
                    temp_block[bcount++] = (byte)':';

                    //InfoLabel.Caption = "Sending record length"
                    //InfoLabel.Refresh
                    //Send the record length
                    temp_block[bcount++] =  (byte)(Record_Length + Length_Padding);

                    //InfoLabel.Caption = "Sending block address"
                    //InfoLabel.Refresh

                    //Send this block's address
                    temp_block[bcount++] = (byte)(Memory_Address_High);
                    temp_block[bcount++] = (byte)(Memory_Address_Low);

                    //InfoLabel.Caption = "Sending checksum"
                    //InfoLabel.Refresh

                    //Send this block's check sum
                    temp_block[bcount++] = (byte)(Check_Sum);

                    //InfoLabel.Caption = "Sending block size " & Record_Length + Length_Padding
                    //InfoLabel.Refresh

                    //Send the block
                    //temp_block = ""
                    for (j = 0; j <= (Record_Length + Length_Padding) - 1; j++)
                    {
                        //MSComm1.Output = Chr(Outgoing_Data(j))
                        temp_block[bcount++] = (byte)(Outgoing_Data[j]);
                        //InfoLabel.Caption = "Sending block - char " & Chr(Outgoing_Data(j)) & " pos " & j
                        //InfoLabel.Refresh

                    }
                    #region old code
                    //MSComm1.Output = temp_block; 
                    #endregion
                    //string data_as_hex = StringToHex(temp_block.ToString());
                    //label4.Text = data_as_hex;
                    //serialPort1.Write(temp_block);
                    //byte[] buff;
                    //buff = new byte[temp_block.Length];
                    //buff = Encoding.ASCII.GetBytes(temp_block);
                    serialPort1.Write(temp_block, 0, bcount);
                    //=============================================
                    InfoLabel.Text = "Done sending block";
                    //InfoLabel.Refresh

                }

            Last_Line:
                //Tell the PIC we are done transmitting data
                #region old code
                //MSComm1.Output = ":";
                //MSComm1.Output = "S"; 
                #endregion
                serialPort1.Write(Encoding.ASCII.GetBytes(":S"), 0, 2);

                lblDownload.Text = "Download Complete!";
                //sptComplete1.FillColor = Color.Green; //Green
                //sptConnect1.FillColor = Color.Green;// 'Green '&HFFFF& //Yellow

                //Turn on the browse buttons
                cmdOpen1.Enabled = true;
                cmdOpen2.Enabled = true;
                cmdOpen3.Enabled = true;
                cmdDownload1.Enabled = true;
                cmdDownload2.Enabled = true;
                cmdDownload3.Enabled = true;
                cmdBreak.Enabled = false;

                //If port already opened then close it
                #region old code
                //if (MSComm1.PortOpen == true)
                //{
                //    MSComm1.PortOpen = false;
                //} 
                #endregion
                if (serialPort1.IsOpen)
                {
                    serialPort1.Close();
                }

                if (TermAutoLaunch) TermWindow(true);

                return;

            #region useless old code
            //ErrHandler:
            //if (Err.Number = 8020 || Err.Number = 8015)
            //{
            //    MessageBox.Show("The PIC seems to be using the UART at a different baud rate. Please power down the PIC or hold it in reset before initiating download.");
            //}
            //else if (Err.Number = 8005)
            //{
            //    MessageBox.Show("COM" + CommPort + " already open.");
            //}
            //else
            //{
            //    MessageBox.Show("Error, " + Err.Description);
            //    MessageBox.Show(Err.Number);
            //}

		            //ErrExit:

            //    //If port already opened then close it
            //    if (MSComm1.PortOpen == true)
            //    {
            //        MSComm1.PortOpen = false;
            //    }

            //    cmdDownload1.Enabled = true;
            //    cmdDownload2.Enabled = true;
            //    cmdDownload3.Enabled = true;
            //    cmdOpen1.Enabled = true;
            //    cmdOpen2.Enabled = true;
            //    cmdOpen3.Enabled = true;
            //    cmdBreak.Enabled = false;

            //    lblStatus.Text = "Error";
            //    lblCurrentBuffer.Text = "Buffer Empty";
            //    lblDownload.Text = "Idle"; 
	        #endregion

            }
            catch (Exception ex)
            {
                //If port already opened then close it
                #region old code
                //if (MSComm1.PortOpen == true)
                //{
                //    MSComm1.PortOpen = false;
                //} 
                #endregion
                if (serialPort1.IsOpen)
                {
                    serialPort1.Close();
                }
                cmdDownload1.Enabled = true;
                cmdDownload2.Enabled = true;
                cmdDownload3.Enabled = true;
                cmdOpen1.Enabled = true;
                cmdOpen2.Enabled = true;
                cmdOpen3.Enabled = true;
                cmdBreak.Enabled = false;

                lblStatus.Text = "Error";
                lblCurrentBuffer.Text = "Buffer Empty";
                lblDownload.Text = "Idle";
                MessageBox.Show(ex.Message);
            }
        }

        private void cmdOpen_Click(object sender, EventArgs e)
        {
            int index = 0;
            TextBox txtFile = null;//u
            if (sender == cmdOpen1)
            {
                txtFile = txtFile1;
                index = 0;
            }
            if (sender == cmdOpen2)
            { txtFile = txtFile2; index = 1; }
            if (sender == cmdOpen3)
            { txtFile = txtFile3; index = 2; }
            try
            {

                // Open a file dialog and let the user select a HEX file
                cd1.Filter = "Hex Files (*.HEX)|*.HEX| All Files (*.*)|*.*";
                cd1.FilterIndex = 1;
                cd1.Title = "Select a file ";

                if (txtUserFile[index] != null && txtUserFile[index].LastIndexOf('\\') > 0)
                    Environment.CurrentDirectory = Path.GetDirectoryName(txtUserFile[index]);
                else
                    Environment.CurrentDirectory = Environment.CurrentDirectory;


                cd1.InitialDirectory = Environment.CurrentDirectory;
                if (cd1.ShowDialog() == DialogResult.OK)
                {
                    if (cd1.FileName != "")
                    {
                        txtFile.Text = cd1.FileName;
                        txtUserFile[index] = cd1.FileName;
                    }
                }

                return;

            }
            catch (Exception ex)
            {
                MessageBox.Show( /*Err.Number & " : " & Err.Description*/ex.Message);
            }
        }

        private void cmdOpenTerminal_Click(object sender, EventArgs e)
        {
            TermWindow(true);
        }

        // taken from http://www.dreamincode.net/code/snippet1821.htm
        private static int Strip(string value)
        {
            string returnVal = string.Empty;
            MatchCollection collection = Regex.Matches(value, "\\d+");
            foreach (Match match in collection)
            {
                returnVal += match.ToString();
            }
            return int.Parse(returnVal);
        }

        private void Command1_Click(object sender, EventArgs e)
        {
            uint convert;

            //    convert = Val("0x" + HexEntry.Text);
            // TODO: Check how this works with hexadecimals
            convert = Convert.ToUInt32(HexEntry.Text, 16); 

            #region old code
            //if (MSComm1.PortOpen) MSComm1.Output = (char)(convert); 
            #endregion
            if (serialPort1.IsOpen)
            {
                Output((int)convert);
            }
        }

        private void screamer_Load(object sender, EventArgs e)
        {
            try
            {
                lblDownload.Width = 0;

                //Read in the settings file - if available
                //using(FileStream fs = File.Open(Path.Combine(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location), settings.txt), FileMode.Open))
                //{
                //}
                string[] s = File.ReadAllText(Path.Combine(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location), "settings.txt")).Split(",".ToCharArray());
                CommPort = int.Parse(s[0]);
                CommSpeed = double.Parse(s[1]);
                PICSpeed = double.Parse(s[2]);
                PICType = s[3];
                txtFile1.Text = s[4];
                txtFile2.Text = s[5];
                txtFile3.Text = s[6];
                TermBaud = double.Parse(s[7]);
                TermDataBits = int.Parse(s[8]);
                TermParity = s[9];
                TermStopBits = double.Parse(s[10]);
                TermType = s[11];
                TermEcho = bool.Parse(s[12]);
                TermAutoLaunch = bool.Parse(s[13]);

                //        Open App.Path & "\" For Input As #1
                //    Input #1, CommPort, CommSpeed, PICSpeed, PICType, txtUserFile(0), txtUserFile(1), txtUserFile(2), _
                //            TermBaud, TermDataBits, TermParity, TermStopBits, TermType, TermEcho, TermAutoLaunch
                //Close #1

                txtFile1.Text = txtUserFile[0];
                txtFile2.Text = txtUserFile[1];
                txtFile3.Text = txtUserFile[2];

                txtComPort.Text = CommPort.ToString();
                //cboCommPort.ListIndex = CommPort - 1

                //If CommSpeed = 9600 Then cboBaud.ListIndex = 0
                //If CommSpeed = 19200 Then cboBaud.ListIndex = 1
                //If CommSpeed = 38400 Then cboBaud.ListIndex = 2
                //If CommSpeed = 57600 Then cboBaud.ListIndex = 3
                //If CommSpeed = 115200 Then cboBaud.ListIndex = 4
                cboBaud.SelectedItem = ((int)CommSpeed).ToString();

                //If PICSpeed = 4 Then cboOscillator.ListIndex = 0
                //If PICSpeed = 8 Then cboOscillator.ListIndex = 1
                //If PICSpeed = 10 Then cboOscillator.ListIndex = 2
                //If PICSpeed = 12 Then cboOscillator.ListIndex = 3
                //If PICSpeed = 16 Then cboOscillator.ListIndex = 4
                //If PICSpeed = 20 Then cboOscillator.ListIndex = 5
                //If PICSpeed = 40 Then cboOscillator.ListIndex = 6
                //If PICSpeed = 48 Then cboOscillator.ListIndex = 7
                //If PICSpeed = 64 Then cboOscillator.ListIndex = 8
                cboOscillator.SelectedItem = ((int)PICSpeed).ToString();


                if ((TermBaud == 1200))
                {
                    cboTermSpeed.SelectedIndex = 0;
                }
                else if ((TermBaud == 2400))
                {
                    cboTermSpeed.SelectedIndex = 1;
                }
                else if ((TermBaud == 4800))
                {
                    cboTermSpeed.SelectedIndex = 2;
                }
                else if ((TermBaud == 19200))
                {
                    cboTermSpeed.SelectedIndex = 4;
                }
                else if ((TermBaud == 38400))
                {
                    cboTermSpeed.SelectedIndex = 5;
                }
                else if ((TermBaud == 57600))
                {
                    cboTermSpeed.SelectedIndex = 6;
                }
                else if ((TermBaud == 115200))
                {
                    cboTermSpeed.SelectedIndex = 7;
                }
                else
                {
                    cboTermSpeed.SelectedIndex = 3;
                }

                if ((TermDataBits == 7))
                {
                    cboTermDataBits.SelectedIndex = 0;
                }
                else
                {
                    cboTermDataBits.SelectedIndex = 1;
                }

                if ((TermParity == "O"))
                {
                    cboTermParity.SelectedIndex = 0;
                }
                else if ((TermParity == "E"))
                {
                    cboTermParity.SelectedIndex = 1;
                }
                else
                {
                    cboTermParity.SelectedIndex = 2;
                }
                if ((TermStopBits == 1.5))
                {
                    cboTermStopBits.SelectedIndex = 1;
                }
                else if ((TermStopBits == 2))
                {
                    cboTermStopBits.SelectedIndex = 2;
                }
                else
                {
                    cboTermStopBits.SelectedIndex = 0;
                }
                if ((TermType == "hex"))
                {
                    optHex.Checked = true;
                }
                else if ((TermType == "dec"))
                {
                    optDec.Checked = true;
                }
                else
                {
                    optAsc.Checked = true;
                }
                if (TermEcho)
                {
                    chkTermEcho.Checked = true;
                }
                if (TermAutoLaunch)
                {
                    chkLaunchTerm.Checked = true;
                }
                return;

            }
            catch (FileNotFoundException)
            {
                SetDefaults();

            }
            catch (IOException) { SetDefaults(); }
            catch (System.Exception ex)
            {


                //If Err.Number = 53 Then 'No File found
                //    'Default values
                //    SetDefaults
                //ElseIf Err.Number = 62 Then
                //    'Problem with the file, close it and set default options
                //    Close #1
                //    'Default values
                //    SetDefaults
                //ElseIf Err.Number = 8021 Then
                //    MSComm1.PortOpen = False
                //    MsgBox ("Whacky problem with serial port")

                //Else
                //    MsgBox Err.Number & " = " & Err.Description
                //End If
                MessageBox.Show(ex.Message);
            }

        }

        private void screamer_FormClosed(object sender, FormClosedEventArgs e)
        {
            try
            {
                // TODO
                //if( TermMode && MSComm1.PortOpen ) MSComm1.PortOpen = false;

                //Open App.Path & "\settings.txt" For Output As #1
                //    Write #1, CommPort, CommSpeed, PICSpeed, PICType, txtUserFile(0), txtUserFile(1), txtUserFile(2), _
                //            TermBaud, TermDataBits, TermParity, TermStopBits, TermType, TermEcho, TermAutoLaunch
                //Close #1
                File.WriteAllText(Path.Combine(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location), "settings.txt"), string.Join(",", new string[]{
        CommPort.ToString(), 
        CommSpeed.ToString().Replace(",", "."), 
        PICSpeed.ToString().Replace(",", "."), 
        PICType, 
        txtFile1.Text, 
        txtFile2.Text, 
        txtFile3.Text, 
                TermBaud.ToString().Replace(",", "."), 
        TermDataBits.ToString(), 
        TermParity, 
        TermStopBits.ToString().Replace(",", "."), 
        TermType, 
        TermEcho.ToString(), 
        TermAutoLaunch.ToString()
    }));//
                return;

            }
            catch (Exception ex)
            {
                MessageBox.Show( /*Err.Number & " = " & Err.Description)*/ex.Message);
            }
        }

        private void optAsc_CheckedChanged(object sender, EventArgs e)
        {
            TermType = "asc";
            if (TermMode) txtTerm.Focus();
        }

        private void optHex_CheckedChanged(object sender, EventArgs e)
        {
            TermType = "hex";
            if (TermMode) txtTerm.Focus();
        }

        private void optDec_CheckedChanged(object sender, EventArgs e)
        {
            TermType = "dec";
            if (TermMode) txtTerm.Focus();
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            Application.DoEvents();
            GetSerial();
            Application.DoEvents();
        }

        private void txtComPort_TextChanged(object sender, EventArgs e)
        {
            try
            {

                if (int.Parse(txtComPort.Text) > 99) txtComPort.Text = "99";

                CommPort = int.Parse(txtComPort.Text);

                return;

            }
            catch
            {
                MessageBox.Show("Comport number must be a number from 1 to 99.");
                txtComPort.Text = "1";
            }
        }

        private void txtFile1_TextChanged(object sender, EventArgs e)
        {
            TextBox tb = (TextBox)sender;
            int index = 0;
            if (tb == txtFile1)
                index = 0;
            if (tb == txtFile2)
                index = 1;
            if (tb == txtFile3)
                index = 2;
            txtUserFile[index] = tb.Text;
        }

        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void txtTerm_Enter(object sender, EventArgs e)
        {

        }

        private void cmdOpenTerminal_KeyPress(object sender, KeyPressEventArgs e)
        {
            MessageBox.Show("key!");
  
        }

        private void txtTerm_TextChanged(object sender, EventArgs e)
        {

        }

        private void serialPort1_DataReceived_1(object sender, System.IO.Ports.SerialDataReceivedEventArgs e)
        {
        }
        private void SetText(string text)
        {
            // InvokeRequired required compares the thread ID of the
            // calling thread to the thread ID of the creating thread.
            // If these threads are different, it returns true.
            if (Pins.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(SetText);
                this.Invoke(d, new object[] { text });
            }
            else
            {
                Pins.Text = text;
            }
        } 
        private void serialPort1_PinChanged(object sender, System.IO.Ports.SerialPinChangedEventArgs e)
        {
            string p = "";
            if (e.EventType == System.IO.Ports.SerialPinChange.Ring)
            {
                p = "Ring";
            }
            if (serialPort1.CDHolding)
            {
                p = p + " CD";
            }
            if (serialPort1.DsrHolding)
            {
                p = p + " DSR";
            }
            if (serialPort1.CtsHolding)
            {
                p = p + " CTS";
            }
            SetText(p);
        
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            if (serialPort1.IsOpen) {
                    serialPort1.DtrEnable = DTRCheckBox.Checked;

            }

        }

        private void RTSCheckBox_CheckedChanged(object sender, EventArgs e)
        {
            if (serialPort1.IsOpen)
            {
                serialPort1.RtsEnable = RTSCheckBox.Checked;

            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            string input = TextEntry.Text;
            //
            // Check each character in the string using for-loop.
            //
            if (serialPort1.IsOpen)
            {
                for (int i = 0; i < input.Length; i++)
                {
                    if (input[i] == '|')
                    {
                        Output(0x0d);
                    }
                    else
                    {
                        Output(input[i]);
                    }
                }
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            serialPort1.Write("clear\rtext 1 128 16 \"AMAZING\"\rpaint\r");
        }
    }
}//8