using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Diagnostics;
using System.IO;

namespace screamer_c
{
    public partial class About : Form
    {
        const int READ_CONTROL = 0x20000;
        const int KEY_QUERY_VALUE = 0x1;
        const int KEY_SET_VALUE = 0x2;
        const int KEY_CREATE_SUB_KEY = 0x4;
        const int KEY_ENUMERATE_SUB_KEYS = 0x8;
        const int KEY_NOTIFY = 0x10;
        const int KEY_CREATE_LINK = 0x20;
        const int KEY_ALL_ACCESS = KEY_QUERY_VALUE + KEY_SET_VALUE +
                               KEY_CREATE_SUB_KEY + KEY_ENUMERATE_SUB_KEYS +
                               KEY_NOTIFY + KEY_CREATE_LINK + READ_CONTROL;

        // Reg Key ROOT Types...
        const uint HKEY_LOCAL_MACHINE = 0x80000002;
        const uint ERROR_SUCCESS = 0;
        const uint REG_SZ = 1;                         // Unicode nul terminated string
        const uint REG_DWORD = 4;                      // 32-bit number

        const string gREGKEYSYSINFOLOC = @"SOFTWARE\Microsoft\Shared Tools Location";
        const string gREGVALSYSINFOLOC = @"MSINFO";
        const string gREGKEYSYSINFO = @"SOFTWARE\Microsoft\Shared Tools\MSINFO";
        const string gREGVALSYSINFO = @"PATH";

        [DllImport("advapi32", EntryPoint = "RegOpenKeyExA")]
        private static extern long RegOpenKeyEx(long hKey, string lpSubKey, long ulOptions, long samDesired, ref long phkResult);
        [DllImport("advapi32", EntryPoint = "RegQueryValueExA")]
        private static extern long RegQueryValueEx(long hKey, string lpValueName, long lpReserved, long lpType, string lpData, ref long lpcbData);
        [DllImport("advapi32", EntryPoint = "RegOpenKeyExA")]
        private static extern long RegCloseKey(long hKey);

        public About()
        {
            InitializeComponent();
        }

        private void About_Load(object sender, EventArgs e)
        {

        }

        private void cmdSysInfo_Click(object sender, EventArgs e)
        {
            StartSysInfo();
        }

        private void StartSysInfo()
        {
            try
            {
                //long rc;
                string SysInfoPath = new string('\0', 1024);

                // Try To Get System Info Program Path\Name From Registry...
                if (GetKeyValue(HKEY_LOCAL_MACHINE, gREGKEYSYSINFO, gREGVALSYSINFO, ref SysInfoPath))
                {
                    // Try To Get System Info Program Path Only From Registry...    
                }
                else if (GetKeyValue(HKEY_LOCAL_MACHINE, gREGKEYSYSINFOLOC, gREGVALSYSINFOLOC, ref SysInfoPath))
                {
                    // Validate Existance Of Known 32 Bit File Version
                    if (File.Exists(Path.Combine(SysInfoPath, "MSINFO32.EXE")))
                    {
                        SysInfoPath = Path.Combine(SysInfoPath, "MSINFO32.EXE");
                    }
                    // Error - File Can Not Be Found...
                    else
                    {
                        MessageBox.Show("System Information Is Unavailable At This Time");
                    }
                }
                // Error - Registry Entry Can Not Be Found...
                else
                    MessageBox.Show("System Information Is Unavailable At This Time");

                Process.Start(SysInfoPath/*, vbNormalFocus*/);
            }
            catch (System.Exception)
            {
                MessageBox.Show("System Information Is Unavailable At This Time");
            }
        }

        public bool GetKeyValue(long KeyRoot, string KeyName, string SubKeyRef, ref string KeyVal)
        {
            int i;
            //  Loop Counter
            long rc;
            //  Return Code
            long hKey = 0;
            //  Handle To An Open Registry Key
            //long hDepth;
            // 
            long KeyValType = 0;
            //  Data Type Of A Registry Key
            string tmpVal = new string('\0', 1024);
            //  Tempory Storage For A Registry Key Value
            long KeyValSize;
            //  Size Of Registry Key Variable
            // ------------------------------------------------------------
            //  Open RegKey Under KeyRoot {HKEY_LOCAL_MACHINE...}
            // ------------------------------------------------------------
            rc = RegOpenKeyEx(KeyRoot, KeyName, 0, KEY_ALL_ACCESS, ref hKey);
            //  Open Registry Key
            if ((rc != ERROR_SUCCESS))
            {
                goto GetKeyError;
            }
            //  Handle Error...
            tmpVal = new string('\0', 1024);
            //  Allocate Variable Space
            KeyValSize = 1024;
            //  Mark Variable Size
            // ------------------------------------------------------------
            //  Retrieve Registry Key Value...
            // ------------------------------------------------------------
            rc = RegQueryValueEx(hKey, SubKeyRef, 0, KeyValType, tmpVal, ref KeyValSize);
            //  Get/Create Key Value
            if ((rc != ERROR_SUCCESS))
            {
                goto GetKeyError;
            }
            //  Handle Errors
            if (((int)(tmpVal.Substring(((int)KeyValSize - 1), 1)[0]) == 0))
            {
                //  Win95 Adds Null Terminated String...
                tmpVal = tmpVal.Substring(0, ((int)KeyValSize - 1));
                //  Null Found, Extract From String
            }
            else
            {
                //  WinNT Does NOT Null Terminate String...
                tmpVal = tmpVal.Substring(0, (int)KeyValSize);
                //  Null Not Found, Extract String Only
            }
            // ------------------------------------------------------------
            //  Determine Key Value Type For Conversion...
            // ------------------------------------------------------------
            switch (KeyValType)
            {
                case REG_SZ:
                    //  String Registry Key Data Type
                    KeyVal = tmpVal;
                    //  Copy String Value
                    break;
                case REG_DWORD:
                    //  Double Word Registry Key Data Type
                    for (i = tmpVal.Length; (i <= 1); i = (i + -1))
                    {
                        //  Convert Each Bit
                        KeyVal = (KeyVal + ((int)(tmpVal.Substring(((int)i - 1), 1)[0])).ToString("X"));
                        //  Build Value Char. By Char.
                    }
                    KeyVal = "0x" + KeyVal;
                    //  Convert Double Word To String
                    break;
            }
            rc = RegCloseKey(hKey);
            //  Close Registry Key
            // TODO: Exit Function: Warning!!! Need to return the value
            return true;
        //  Exit
        GetKeyError:
            KeyVal = "";
            rc = RegCloseKey(hKey);
            return false;
            //  Close Registry Key
        }

        private void label3_Click(object sender, EventArgs e)
        {

        }
    }
}